unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  System.Runtime.Serialization,
  System.Runtime.Serialization.Formatters.Binary,
  System.Runtime.Serialization.Formatters.Soap,
  System.IO;

type
  [Serializable()]
  TActiveDelphiObj = class(System.Object)
  private
    FCodigo: Integer;
    [NonSerialized]
    FNome: String;
    function GetCodigo: Integer;
    function GetNome: String;
    procedure SetCodigo(const Value: Integer);
    procedure SetNome(const Value: String);
    property Codigo: Integer read GetCodigo write SetCodigo;
    property Nome: String read GetNome write SetNome;
  end;

  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(23, 28);
  Self.Button1.Name := 'Button1';
  Self.Button1.Size := System.Drawing.Size.Create(117, 23);
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Serializar Objeto';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(334, 244);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'Serializando Objetos :: Active Delphi';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  formatter: IFormatter;
  strStream: Stream;
  ADObj: TActiveDelphiObj;
begin
  strStream := nil;
  try
    ADObj := TActiveDelphiObj.Create;
    ADObj.Codigo := 1;
    ADObj.Nome := 'Active Delphi';

    formatter := BinaryFormatter.Create;
    strStream := FileStream.Create('C:\MyFile.bin', FileMode.Create, FileAccess.Write, FileShare.None);
    formatter.Serialize(strStream, ADObj);

    strStream.Close();

    formatter := SoapFormatter.Create;
    strStream := FileStream.Create('C:\MyFile.xml', FileMode.Create, FileAccess.Write, FileShare.None);
    formatter.Serialize(strStream, ADObj);

    strStream.Close();

    MessageBox.Show('Objeto serializado com sucesso. Serializao no C:\'); 
  except
    on E: Exception do
    begin
      MessageBox.Show(E.Message);
      strStream.Close();
    end;
  end;
end;

{ TActiveDelphiObj }

function TActiveDelphiObj.GetCodigo: Integer;
begin
  Result := FCodigo;
end;

function TActiveDelphiObj.GetNome: String;
begin
  Result := FNome;
end;

procedure TActiveDelphiObj.SetCodigo(const Value: Integer);
begin
  if Value <> FCodigo then
    FCodigo := Value;
end;

procedure TActiveDelphiObj.SetNome(const Value: String);
begin
  if Value <> FNome then
    FNome := Value;
end;

end.
